<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');



class Aqadmin extends CI_Controller 

{

	

	public function __construct()

	{

		parent::__construct();
	
		$this->load->library('form_validation');
		$this->load->model('aqadmin_model');		
		$this->load->library("pagination");
		$this->clear_cache();	
		define( 'SERVER_KEY', 'AAAA1CNpN5U:APA91bEqX8wnND4s74HM05GBogdOvhy99_te7ZZvgCzETTchl9j0MoYoDl5CxNehv5NRwjWI7v3gp-AqcxMA6ykPiU9zkEvYeRZWEyQMeAwY7TvI4YgSa8eqdWhed7BQZ0pmmjv3_kWt' );
	}
	function index()
	{
		$this->form_validation->set_rules('email', 'Email', 'trim|required|xss_clean');
		$this->form_validation->set_rules('password', 'Password','trim|required|xss_clean|callback_check_database');		
		if($this->form_validation->run() == FALSE)
		{	
			$datas['value']=0;
			$admin=$this->session->userdata('alogged_in');					
			$datas['login']=$admin;	
		    $this->load->view('login/login_view',$datas);
		}
		else{
		$email =$this->input->post("email");
		$password =md5($this->input->post("password"));
		$result = $this->aqadmin_model->login($email, $password);
	 	if($result==FALSE)
		{
			$datas['value']=1;
			$datas['msg']="Incorrect username or password";
			$admin=$this->session->userdata('alogged_in');					
			$datas['login']=$admin;	
            $this->load->view('login/login_view',$datas);
		}else
		{
			$sess_array = array();
			foreach($result as $row){			
				$sess_array = array('log_id' => $row->a_id,'email' => $row->email,'password' => $row->password,'role' => $row->role,'link' => $row->link);            
				$this->session->set_userdata('alogged_in', $sess_array);
				$admin=$this->session->userdata('alogged_in');		
				
				if($admin['role']=='super')
				{
					$this->session->set_userdata('user','admin');
					/*$this->session->set_userdata('adid','1');*/
				}
				else
				{
					$this->session->set_userdata('user','staff');
					/*$this->session->set_userdata('adid',$admin['log_id']);*/
				}
	}
	if($this->session->userdata('alogged_in'))
			{
			
       redirect('aqadmin/dashboard');

			}	
		}
		}
}

    function dashboard()
	{
	    
		$admin=$this->session->userdata('alogged_in');					
		$datas['login']=$admin;	
		$this->session->set_userdata('active_menu', "dashboard");
		$datas['active_menu']="dashboard";
		$this->load->view('layout/header_view',$datas);
		$this->load->view('layout/sidebar_view',$datas);
		$this->load->view('dashboard/dash_view',$datas);
		$this->load->view('layout/footer_view');		
     }
      
	function edit_profile()
	{
		$admin=$this->session->userdata('alogged_in');	

		$adid=$admin['log_id']; 
		$this->session->set_userdata('adid',$adid);
		$this->form_validation->set_rules('adname', 'Name','trim|xss_clean');
		$this->form_validation->set_rules('email', 'Email','trim|xss_clean');
		
		if($this->form_validation->run() == FALSE)
		{ 
			$con=array('a_id'=>$adid);
			$datas['adm']=$this->aqadmin_model->select_condn('exp_admin',$con);    
			$admin=$this->session->userdata('alogged_in');					
			$datas['login']=$admin;	
			$datas['active_menu']="dashboard";	
			$this->load->view('layout/header_view',$datas);
			$this->load->view('layout/sidebar_view',$datas);
			$this->load->view('admin/edit_profile',$datas);
			$this->load->view('layout/footer_view');
		}
		else
		{
			$adid=$this->session->userdata('adid'); 
			
			$nam=$this->input->post("adname");
			$email=$this->input->post("email");
			
	        $con=array('a_id'=>$adid);
			$data=array('username'=>$nam,'email'=>$email);
			$this->aqadmin_model->updatedata('exp_admin',$data,$con);
			$this->session->set_flashdata('success_msg', 'Admin details updated');
	    	redirect('aqadmin/edit_profile');
    	
		}
	}
	function change_password()
	{
		$this->form_validation->set_rules('old_password', 'Old Password', 'trim|required|xss_clean');
		$this->form_validation->set_rules('new_password', 'New Password', 'trim|required|xss_clean');
		$this->form_validation->set_rules('confirm_password', 'Confirm Password', 'trim|required|matches[new_password]');
		
		if($this->form_validation->run() == FALSE)
		{ 
			$con=array('a_id'=>1);
			$datas['adm']=$this->aqadmin_model->select_condn('exp_admin',$con);    
			$admin=$this->session->userdata('alogged_in');					
			$datas['login']=$admin;	
			$datas['active_menu']="dashboard";	
			$this->load->view('layout/header_view',$datas);
			$this->load->view('layout/sidebar_view',$datas);
			$this->load->view('admin/edit_profile',$datas);
			$this->load->view('layout/footer_view');

					
		}
		else
		{
			$admin=$this->session->userdata('alogged_in');
			$adminmail=$admin['email']; 
			$old_password=md5($this->input->post("old_password"));
			$con=array('email'=>$adminmail,'password'=>$old_password);
			$result=$this->aqadmin_model->select_condn('exp_admin',$con);  
			if(count($result)==1)
			{
				$new_password=md5($this->input->post("new_password"));
				$con=array('email'=>$adminmail);
				$data=array('password'=>$new_password);
				$this->aqadmin_model->updatedata('exp_admin',$data,$con);
				$this->session->set_flashdata('pwd_success_msg', 'Password changed successfully');
				redirect('aqadmin/edit_profile');
			}
					
			else
			{
				$this->session->set_flashdata('pwd_success_msg', 'Wrong password entered');
			   	redirect('aqadmin/edit_profile');
			}	

					
		}
	}
	function forgot_password()
	{
		$this->form_validation->set_rules('email', 'Email', 'trim|required|xss_clean');
			
		if($this->form_validation->run() == FALSE)
		{	
			$datas['value']=0;
		    $this->load->view('login/forgot_password',$datas);
		}
		else
		{
			$email =$this->input->post("email");
			$result = $this->aqadmin_model->select_admin_email($email);
		 	if($result==FALSE)
			{
				$datas['value']=1;
				$datas['msg']="Mail Id does not exist.";
				
	            $this->load->view('login/forgot_password',$datas);
			}
			else
			{
				$token=md5(uniqid(rand(), true));
				
				foreach($result as $row)
				{
					$login_id=$row->a_id;
					$login_email=$row->email;
					$data=array('reset_token'=>$token);
					$condn=array('a_id'=>$login_id);
					$update=$this->aqadmin_model->updatedata('exp_admin',$data,$condn);
										
				}
				$today=strtotime(date('d-m-Y H:i'));
				$resetlink=base_url()."index.php/aqadmin/reset_admin_password/".$login_id."/".$today."/".$token;

				

				$to = $login_email;
				$subject = "Password Reset".date('d/m/Y H:i:s');

				$message = "
					<html>
					<head>
					<title>Password Reset Link</title>
					</head>
					<body>
					<p>Click the link below to Reset password.</p>
				<p><a href='".$resetlink."' target='blank'>Click to reset</a></p>
				</body>
					<p>If clicking doesn't seem to work, you can copy and paste the link into your browser's address window.</p></br>".$resetlink."

					<p>Thanks<br>
					<b>Expert Solutions</b></p>
					</body>
					</html>
					";

				// Always set content-type when sending HTML email
				$headers = "MIME-Version: 1.0" . "\r\n";
				$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

				// More headers
				$headers .= 'From: <password.reset@expertsolutions.com>' . "\r\n";
				

				$check=mail($to,$subject,$message,$headers);
				


				$datas['value']=1;
				$datas['msg']="Resetlink is send to the given mail id.";
				$datas['resetlink']=$resetlink;
	            $this->load->view('login/forgot_password',$datas);
			}
		}
	}
	function reset_admin_password()
	{
		if($this->input->post("token"))
		{
			$token=$this->input->post("token");
			$login_id=$this->input->post("login_id");
			$link_date=$this->input->post("link_date");
		}
		else
		{
			$token=$this->uri->segment(5);
			$link_date=$this->uri->segment(4);
			$login_id=$this->uri->segment(3);
		}
		
		$todate=strtotime(date('d-m-Y H:i'));
		$diff=$todate-$link_date;
		// echo $diff;
		if (($todate - $link_date) < 86400) 
		{
			$this->form_validation->set_rules('new_password', 'New Password', 'trim|required|xss_clean');
			$this->form_validation->set_rules('confirm_password', 'Confirm Password', 'trim|required|matches[new_password]');
			if($this->form_validation->run() == FALSE)
			{	
				$datas['value']=0;
				$datas['token']=$token;
				$datas['login_id']=$login_id;
				$datas['link_date']=$link_date;
				$this->load->view('login/reset_admin_password',$datas);
			}
			else
			{
				$condn=array('a_id'=>$login_id,'reset_token'=>$token);
				$result=$this->aqadmin_model->select_condn('exp_admin',$condn);
				// echo $result->num_rows();
				
				if($result->num_rows()==1)
				{
					$password =md5($this->input->post("new_password"));
					$data=array('password'=>$password,'reset_token'=>NULL);
					$condn=array('a_id'=>$login_id);
					$update=$this->aqadmin_model->updatedata('exp_admin',$data,$condn);
					$datas['value']=1;
					$datas['msg']="Password reset successfully.";
					$admin=$this->session->userdata('alogged_in');					
					$datas['login']=$admin;	
		            $this->load->view('login/login_view',$datas);
				}
				else
				{
					$datas['value']=1;
					$datas['msg']="Link expired. Please enter mail id.";
				
		    		$this->load->view('login/forgot_password',$datas);
				}
				
			}
		}
		else
		{
			if($token==NULL)
			{
				/*$datas['value']=0;
				
				$admin=$this->session->userdata('alogged_in');					
				$datas['login']=$admin;	
	            $this->load->view('login/login_view',$datas);*/
	            redirect('aqadmin/index');
			}
			else
			{
				$datas['value']=1;
				$datas['msg']="Link expired. Please enter mail id.";
				
		    	$this->load->view('login/forgot_password',$datas);
			}
			
		}
		
		
	}
	function view_testimonials()
	{
		
	    $datas['testimonials']=$this->aqadmin_model->select('exp_testimonials');
	
		$admin=$this->session->userdata('alogged_in');					
		$datas['login']=$admin;	
		$datas['active_menu']="testimonials";
		$this->load->view('layout/header_view',$datas);
		$this->load->view('layout/sidebar_view',$datas);
		$this->load->view('testimonials/view_testimonials',$datas);
		$this->load->view('layout/footer_view');		
    }
    function add_testimonials()
	{
		$id=$this->input->post('id');
		$this->form_validation->set_rules('testimonial', 'Testimonial','trim|required|xss_clean');
		// $this->form_validation->set_rules('b2b_ar_catnam', 'b2b_ar_catnam','trim|required|xss_clean');
		if($this->input->post('client_id')==0)
		{
			$this->form_validation->set_rules('name', 'Name','trim|required|xss_clean');
		}
		
		$this->form_validation->set_rules('loc', 'Location','trim|required|xss_clean');
				
		if($this->form_validation->run() == FALSE)
		{
        	
        	if($id=="")
        	{
        		$admin=$this->session->userdata('alogged_in');					
				$datas['login']=$admin;	
				$datas['active_menu']="testimonials";
				$this->load->view('layout/header_view',$datas);
				$this->load->view('layout/sidebar_view',$datas);
				$this->load->view('testimonials/add_testimonials',$datas);
				$this->load->view('layout/footer_view');
        	}
        	else
        	{
        		redirect('aqadmin/edit_testimonials?id='.$id);
        	}
			
		}
		else
		{
		
		$testimonial=$this->input->post("testimonial");
		// $b2b_ar_catnam=$this->input->post("b2b_ar_catnam");
		$client_id=$this->input->post('client_id');
		if($client_id==0)
		{
			$name=$this->input->post("name");
		}
		else
		{
			$name=NULL;
		}
		$location=$this->input->post("loc");
		$date=date("Y/m/d");
		$data=array('testimonial'=>$testimonial,'client_id'=>$client_id,'name'=>$name,'location'=>$location,'date'=>$date);
		if($id=="")
		{
			$this->aqadmin_model->insert('exp_testimonials',$data);
		}
		
		else
		{
			$con=array('id'=>$id);
			$this->aqadmin_model->updatedata('exp_testimonials',$data,$con);
		}
		$this->session->set_flashdata('success_msg', 'Testimonial added successfully');
    	redirect('aqadmin/view_testimonials');
		}
	}
	function edit_testimonials()
	{
		$id=$this->uri->segment(3);

		$con=array('id'=>$id);
	    $datas['testimonial_row']=$this->aqadmin_model->select_single('exp_testimonials',$con);
	        
		$admin=$this->session->userdata('alogged_in');					
		$datas['login']=$admin;	
		$datas['active_menu']="testimonials";
		$this->load->view('layout/header_view',$datas);
		$this->load->view('layout/sidebar_view',$datas);
		$this->load->view('testimonials/add_testimonials',$datas);
		$this->load->view('layout/footer_view');
		
		
	}	
	function delete_testimonials()
	{
		$id = $this->input->get('id');
		
		$condn=array('id' => $id);
		$this->admin_model->delete_single('exp_testimonials',$condn);
		redirect('testimonials/view_testimonials');
	}
	function view_brands()
	{
		
	    $datas['brands']=$this->aqadmin_model->select('exp_brands');
	
		$admin=$this->session->userdata('alogged_in');					
		$datas['login']=$admin;	
		$datas['active_menu']="brands";
		$this->load->view('layout/header_view',$datas);
		$this->load->view('layout/sidebar_view',$datas);
		$this->load->view('brands/view_brands',$datas);
		$this->load->view('layout/footer_view');		
    }
	function add_brands()
	{
		$id=$this->input->post('id');

		$this->form_validation->set_rules('brand_name', 'Brand Name','trim|required|xss_clean');
		// $this->form_validation->set_rules('brand_logo', 'Logo','trim|required|xss_clean');
				
		if($this->form_validation->run() == FALSE)
		{
        	
        	if($id=="")
        	{
        		$admin=$this->session->userdata('alogged_in');					
				$datas['login']=$admin;	
				$datas['active_menu']="brands";
				$this->load->view('layout/header_view',$datas);
				$this->load->view('layout/sidebar_view',$datas);
				$this->load->view('brands/add_brands',$datas);
				$this->load->view('layout/footer_view');
        	}
        	else
        	{
        		redirect('aqadmin/edit_brands?id='.$id);
        	}
			
		}
		else
		{
		
		$brand_name=$this->input->post("brand_name");
		$old_brand_image=$this->input->post('old_brand_image');
        if (!empty($_FILES['brand_image']['name']))
            {
                
                if($old_brand_image=="" || $old_brand_image==NULL)
                {

                }
                else
                {
                    $unlink="../uploads/brand_image/".$old_brand_image;
                    unlink($unlink);
                    $unlink="../uploads/brand_image/thumbs/".$old_brand_image;
                    unlink($unlink);
                }
                $ext=pathinfo($_FILES['brand_image']['name'], PATHINFO_EXTENSION);
                        
                $imgname = current(explode(".",$_FILES['brand_image']['name']));
                $extarray = array("jpg","JPG","JPEG","jpeg","gif","GIF","png","PNG");
                       
                if(in_array($ext,$extarray))
                { 
                    // echo "hii";
                    $this->load->helper("url"); 
                    $basepath = "../uploads/brand_image/";             
                    $randomnumber = rand(123456,654321);            
                    $newfilename = "img".$randomnumber . "." . $ext ;           
                    $target_path = $basepath . $newfilename ;              
                                      
                                
                    if (move_uploaded_file($_FILES['brand_image']['tmp_name'],$target_path))
                    {       
                        $img_url = $target_path;
                        $basepath1 = "../uploads/brand_image/thumbs/";
                        $resize_path1 = $basepath1 . $newfilename ;
                        $this->load->library('image_lib');
                        $config['image_library'] = 'gd2';
                        $config['source_image']  = $target_path;
                        $config['create_thumb'] = FALSE;
                        $config['maintain_ratio'] = TRUE;
                        $config['new_image']  =$resize_path1;
                        $config['width'] = 50;
                        $config['height'] = 50;
                        //$config['master_dim'] = 'height';
                              
                        $this->image_lib->initialize($config);
                                
                        if(!$this->image_lib->resize())
                        {
                            echo "Image is not resized"."<br>";
                            echo $this->image_lib->display_errors();
                                    $this->image_lib->clear();
                        }
                    }
                }
            }
            else
            {
                $newfilename=$old_brand_image;
                
            }


        $old_brand_logo=$this->input->post('old_brand_logo');
        if (!empty($_FILES['brand_logo']['name']))
            {
                
                if($old_brand_logo=="" || $old_brand_logo==NULL)
                {

                }
                else
                {
                    $unlink="../uploads/brand_logo/".$old_brand_logo;
                    unlink($unlink);
                    $unlink="../uploads/brand_logo/thumbs/".$old_brand_logo;
                    unlink($unlink);
                }
                $ext=pathinfo($_FILES['brand_logo']['name'], PATHINFO_EXTENSION);
                        
                $imgname = current(explode(".",$_FILES['brand_logo']['name']));
                $extarray = array("jpg","JPG","JPEG","jpeg","gif","GIF","png","PNG");
                       
                if(in_array($ext,$extarray))
                { 
                    // echo "hii";
                    $this->load->helper("url"); 
                    $basepath =  "../uploads/brand_logo/";             
                    $randomnumber = rand(123456,654321);            
                    $newfilename2 = "logo".$randomnumber . "." . $ext ;           
                    $target_path = $basepath . $newfilename2 ;              
                                      
                                
                    if (move_uploaded_file($_FILES['brand_logo']['tmp_name'],$target_path))
                    {       
                        $img_url = $target_path;
                        $basepath1 = "../uploads/brand_logo/thumbs/";
                        $resize_path1 = $basepath1 . $newfilename2 ;
                        $this->load->library('image_lib');
                        $config['image_library'] = 'gd2';
                        $config['source_image']  = $target_path;
                        $config['create_thumb'] = FALSE;
                        $config['maintain_ratio'] = TRUE;
                        $config['new_image']  =$resize_path1;
                        $config['width'] = 50;
                        $config['height'] = 50;
                        //$config['master_dim'] = 'height';
                              
                        $this->image_lib->initialize($config);
                                
                        if(!$this->image_lib->resize())
                        {
                            echo "Image is not resized"."<br>";
                            echo $this->image_lib->display_errors();
                                    $this->image_lib->clear();
                        }
                    }
                }
            }
            else
            {
                $newfilename2=$old_brand_logo;
                
            }
		$data=array('brand_name'=>$brand_name,'brand_image'=>$newfilename,'brand_logo'=>$newfilename2);
		if($id=="")
		{
			$this->aqadmin_model->insert('exp_brands',$data);
		}
		
		else
		{
			$con=array('id'=>$id);
			$this->aqadmin_model->updatedata('exp_brands',$data,$con);
		}
		$this->session->set_flashdata('success_msg', 'Brand added successfully');
    	redirect('aqadmin/view_brands');
		}
	}
	function edit_brands()
	{
		$id=$this->uri->segment(3);

		$con=array('id'=>$id);
	    $datas['brand_row']=$this->aqadmin_model->select_single('exp_brands',$con);
	        
		$admin=$this->session->userdata('alogged_in');					
		$datas['login']=$admin;	
		$datas['active_menu']="brands";
		$this->load->view('layout/header_view',$datas);
		$this->load->view('layout/sidebar_view',$datas);
		$this->load->view('brands/add_brands',$datas);
		$this->load->view('layout/footer_view');
		
		
	}	
	function delete_brand()
	{
		$id = $this->input->segment('id');
		$condn=array('id' => $id);
		$brand_row=$this->aqadmin_model->select_single('exp_brands',$condn);
		if($brand_row->brand_image!=NULL || $brand_row->brand_image!="")
		{
			$unlink="../uploads/brand_image/".$brand_row->brand_image;
            unlink($unlink);
            $unlink="../uploads/brand_image/thumbs/".$brand_row->brand_image;
            unlink($unlink);
		}
		if($brand_row->brand_logo!=NULL || $brand_row->brand_logo!="")
		{
			$unlink="../uploads/brand_logo/".$brand_row->brand_logo;
            unlink($unlink);
            $unlink="../uploads/brand_logo/thumbs/".$brand_row->brand_logo;
            unlink($unlink);
		}
		$condn=array('id' => $id);
		$this->admin_model->delete_single('exp_brands',$condn);
		redirect('brands/view_brands');
	}
	function brand_status_change()
	{
		$id = $this->input->get('id');
		$status = $this->input->get('sta');
		if($status == 1)
		{
			$data = array('active' => 0);
		}
		else
		{
			$data = array('active' => 1);
		}
		$condn=array('id' => $id);
		$this->admin_model->updatedata('exp_brands',$data,$condn);
		redirect('brands/view_brands');
	}
	function view_slider()
	{
		
	    $datas['slider']=$this->aqadmin_model->select('exp_slider');
	
		$admin=$this->session->userdata('alogged_in');					
		$datas['login']=$admin;	
		$datas['active_menu']="slider";
		$this->load->view('layout/header_view',$datas);
		$this->load->view('layout/sidebar_view',$datas);
		$this->load->view('slider/view_slider',$datas);
		$this->load->view('layout/footer_view');		
    }
	function add_slider()
	{
		$id=$this->input->post('id');

		$this->form_validation->set_rules('slider_name', 'Slider Name','trim|required|xss_clean');
		// $this->form_validation->set_rules('brand_logo', 'Logo','trim|required|xss_clean');
				
		if($this->form_validation->run() == FALSE)
		{
        	
        	if($id=="")
        	{
        		$admin=$this->session->userdata('alogged_in');					
				$datas['login']=$admin;	
				$datas['active_menu']="slider";
				$this->load->view('layout/header_view',$datas);
				$this->load->view('layout/sidebar_view',$datas);
				$this->load->view('slider/add_slider',$datas);
				$this->load->view('layout/footer_view');
        	}
        	else
        	{
        		redirect('aqadmin/edit_slider?id='.$id);
        	}
			
		}
		else
		{
		
		$slider_name=$this->input->post("slider_name");
		$main_caption=$this->input->post("main_caption");
		$sub_caption=$this->input->post("sub_caption");
		
		$old_brand_image=$this->input->post('old_brand_image');
        if (!empty($_FILES['slider_image']['name']))
            {
                
                if($old_brand_image=="" || $old_brand_image==NULL)
                {

                }
                else
                {
                    $unlink="../uploads/slider/".$old_brand_image;
                    unlink($unlink);
                    $unlink="../uploads/slider/thumbs/".$old_brand_image;
                    unlink($unlink);
                }
                $ext=pathinfo($_FILES['slider_image']['name'], PATHINFO_EXTENSION);
                        
                $imgname = current(explode(".",$_FILES['slider_image']['name']));
                $extarray = array("jpg","JPG","JPEG","jpeg","gif","GIF","png","PNG");
                       
                if(in_array($ext,$extarray))
                { 
                    // echo "hii";
                    $this->load->helper("url"); 
                    $basepath = "../uploads/slider/";             
                    $randomnumber = rand(123456,654321);            
                    $newfilename = "img".$randomnumber . "." . $ext ;           
                    $target_path = $basepath . $newfilename ;              
                                      
                                
                    if (move_uploaded_file($_FILES['slider_image']['tmp_name'],$target_path))
                    {       
                        $img_url = $target_path;
                        $basepath1 = "../uploads/slider/thumbs/";
                        $resize_path1 = $basepath1 . $newfilename ;
                        $this->load->library('image_lib');
                        $config['image_library'] = 'gd2';
                        $config['source_image']  = $target_path;
                        $config['create_thumb'] = FALSE;
                        $config['maintain_ratio'] = TRUE;
                        $config['new_image']  =$resize_path1;
                        $config['width'] = 50;
                        $config['height'] = 50;
                        //$config['master_dim'] = 'height';
                              
                        $this->image_lib->initialize($config);
                                
                        if(!$this->image_lib->resize())
                        {
                            echo "Image is not resized"."<br>";
                            echo $this->image_lib->display_errors();
                                    $this->image_lib->clear();
                        }
                    }
                }
            }
            else
            {
                $newfilename=$old_brand_image;
                
            }


        
		$data=array('slider_name'=>$slider_name,'slider_image'=>$newfilename,'main_caption'=>$main_caption,'sub_caption'=>$sub_caption);
		if($id=="")
		{
			$this->aqadmin_model->insert('exp_slider',$data);
		}
		
		else
		{
			$con=array('id'=>$id);
			$this->aqadmin_model->updatedata('exp_slider',$data,$con);
		}
		$this->session->set_flashdata('success_msg', 'Slider added successfully');
    	redirect('aqadmin/view_slider');
		}
	}
	function edit_slider()
	{
		$id=$this->uri->segment(3);

		$con=array('id'=>$id);
	    $datas['slider_row']=$this->aqadmin_model->select_single('exp_slider',$con);
	        
		$admin=$this->session->userdata('alogged_in');					
		$datas['login']=$admin;	
		$datas['active_menu']="slider";
		$this->load->view('layout/header_view',$datas);
		$this->load->view('layout/sidebar_view',$datas);
		$this->load->view('slider/add_slider',$datas);
		$this->load->view('layout/footer_view');
		
		
	}	
	function delete_slider()
	{
		$id = $this->input->segment('id');
		$condn=array('id' => $id);
		$slider_row=$this->aqadmin_model->select_single('exp_slider',$condn);
		if($slider_row->slider_image!=NULL || $slider_row->slider_image!="")
		{
			$unlink="../uploads/slider/".$slider_row->slider_image;
            unlink($unlink);
            $unlink="../uploads/slider/thumbs/".$slider_row->slider_image;
            unlink($unlink);
		}
		
		$condn=array('id' => $id);
		$this->admin_model->delete_single('exp_slider',$condn);
		redirect('slider/view_slider');
	}
	function slider_status_change()
	{
		$id = $this->input->get('id');
		$status = $this->input->get('sta');
		if($status == 1)
		{
			$data = array('active' => 0);
		}
		else
		{
			$data = array('active' => 1);
		}
		$condn=array('id' => $id);
		$this->admin_model->updatedata('exp_slider',$data,$condn);
		redirect('slider/view_slider');
	}
	function view_bookings()
	{
		$datas['bookings']=$this->aqadmin_model->select('exp_bookings','status,appointment_date','ASC');
	
		$admin=$this->session->userdata('alogged_in');					
		$datas['login']=$admin;	
		$datas['active_menu']="bookings";
		$this->load->view('layout/header_view',$datas);
		$this->load->view('layout/sidebar_view',$datas);
		$this->load->view('bookings/view_bookings',$datas);
		$this->load->view('layout/footer_view');
    }
	function view_bookingdetails()
	{
		$id = $this->input->get('id');
		$condn=array('id' => $id);
	    $datas['booking_row']=$this->aqadmin_model->select_single('exp_bookings',$condn);
	
		$admin=$this->session->userdata('alogged_in');					
		$datas['login']=$admin;	
		$datas['active_menu']="bookings";
		$this->load->view('layout/header_view',$datas);
		$this->load->view('layout/sidebar_view',$datas);
		$this->load->view('bookings/view_booking_details',$datas);
		$this->load->view('layout/footer_view');	
		
    }
	
	function view_service()
	{
		
	    $datas['service']=$this->aqadmin_model->select('exp_service');
	
		$admin=$this->session->userdata('alogged_in');					
		$datas['login']=$admin;	
		$datas['active_menu']="service";
		$this->load->view('layout/header_view',$datas);
		$this->load->view('layout/sidebar_view',$datas);
		$this->load->view('service/view_service',$datas); 
		$this->load->view('layout/footer_view');		
    }
	
	function add_service()
	{
		$id=$this->input->post('id');

		$this->form_validation->set_rules('service_type', 'Service Type','trim|required|xss_clean');
		// $this->form_validation->set_rules('brand_logo', 'Logo','trim|required|xss_clean');
				
		if($this->form_validation->run() == FALSE)
		{
        	
        	if($id=="")
        	{
        		$admin=$this->session->userdata('alogged_in');					
				$datas['login']=$admin;	
				$datas['active_menu']="service";
				$this->load->view('layout/header_view',$datas);
				$this->load->view('layout/sidebar_view',$datas);
				$this->load->view('service/add_service',$datas);
				$this->load->view('layout/footer_view');
        	}
        	else
        	{
        		redirect('aqadmin/edit_service?id='.$id);
        	}
			
		}
		else
		{
		
		$service_type=$this->input->post("service_type");
		$booking_type=$this->input->post("booking_type");
		
		
		$data=array('service_type'=>$service_type,'booking_type'=>$booking_type);
		if($id=="")
		{
			$this->aqadmin_model->insert('exp_service',$data);
		}
		
		else
		{
			$con=array('id'=>$id);
			$this->aqadmin_model->updatedata('exp_service',$data,$con);
		}
		$this->session->set_flashdata('success_msg', 'service added successfully');
    	redirect('aqadmin/view_service');
		}
	}
	function edit_service()
	{
		$id=$this->uri->segment(3);

		$con=array('id'=>$id);
	    $datas['service_row']=$this->aqadmin_model->select_single('exp_service',$con);
	        
		$admin=$this->session->userdata('alogged_in');					
		$datas['login']=$admin;	
		$datas['active_menu']="service";
		$this->load->view('layout/header_view',$datas);
		$this->load->view('layout/sidebar_view',$datas);
		$this->load->view('service/add_service',$datas);
		$this->load->view('layout/footer_view');
		
		
	}	
	function delete_service()
	{
		$id = $this->input->segment('id');
		$condn=array('id' => $id);
		$service_row=$this->aqadmin_model->select_single('exp_service',$condn);
		
		
		$condn=array('id' => $id);
		$this->admin_model->delete_single('exp_service',$condn);
		redirect('service/view_service');
	}
	function service_status_change()
	{
		$id = $this->input->get('id');
		$status = $this->input->get('sta');
		if($status == 1)
		{
			$data = array('active' => 0);
		}
		else
		{
			$data = array('active' => 1);
		}
		$condn=array('id' => $id);
		$this->admin_model->updatedata('exp_service',$data,$condn);
		redirect('service/view_service');
	}
	
    function view_clients()
	{
		
	    $datas['clients']=$this->aqadmin_model->select('exp_clients');
	
		$admin=$this->session->userdata('alogged_in');					
		$datas['login']=$admin;	
		$datas['active_menu']="clients";
		$this->load->view('layout/header_view',$datas);
		$this->load->view('layout/sidebar_view',$datas);
		$this->load->view('clients/view_clients',$datas);
		$this->load->view('layout/footer_view');		
    }
	function add_clients()
	{
		$id=$this->input->post('id');

		$this->form_validation->set_rules('client_name', 'Client Name','trim|required|xss_clean');
		// $this->form_validation->set_rules('brand_logo', 'Logo','trim|required|xss_clean');
				
		if($this->form_validation->run() == FALSE)
		{
        	
        	if($id=="")
        	{
        		$admin=$this->session->userdata('alogged_in');					
				$datas['login']=$admin;	
				$datas['active_menu']="clients";
				$this->load->view('layout/header_view',$datas);
				$this->load->view('layout/sidebar_view',$datas);
				$this->load->view('clients/add_clients',$datas);
				$this->load->view('layout/footer_view');
        	}
        	else
        	{
        		redirect('aqadmin/edit_clients?id='.$id);
        	}
			
		}
		else
		{
		
		$client_name=$this->input->post("client_name");
		$nature_of_work=$this->input->post("nature_of_work");
		$client_desc=$this->input->post("description");
		
        $old_client_logo=$this->input->post('old_client_logo');
        if (!empty($_FILES['client_logo']['name']))
            {
                
                if($old_client_logo=="" || $old_client_logo==NULL)
                {

                }
                else
                {
                    $unlink="../uploads/client_logo/".$old_client_logo;
                    unlink($unlink);
                    $unlink="../uploads/client_logo/thumbs/".$old_client_logo;
                    unlink($unlink);
                }
                $ext=pathinfo($_FILES['client_logo']['name'], PATHINFO_EXTENSION);
                        
                $imgname = current(explode(".",$_FILES['client_logo']['name']));
                $extarray = array("jpg","JPG","JPEG","jpeg","gif","GIF","png","PNG");
                       
                if(in_array($ext,$extarray))
                { 
                    // echo "hii";
                    $this->load->helper("url"); 
                    $basepath =  "../uploads/client_logo/";             
                    $randomnumber = rand(123456,654321);            
                    $newfilename2 = "logo".$randomnumber . "." . $ext ;           
                    $target_path = $basepath . $newfilename2 ;              
                                      
                                
                    if (move_uploaded_file($_FILES['client_logo']['tmp_name'],$target_path))
                    {       
                        $img_url = $target_path;
                        $basepath1 = "../uploads/client_logo/thumbs/";
                        $resize_path1 = $basepath1 . $newfilename2 ;
                        $this->load->library('image_lib');
                        $config['image_library'] = 'gd2';
                        $config['source_image']  = $target_path;
                        $config['create_thumb'] = FALSE;
                        $config['maintain_ratio'] = TRUE;
                        $config['new_image']  =$resize_path1;
                        $config['width'] = 50;
                        $config['height'] = 50;
                        //$config['master_dim'] = 'height';
                              
                        $this->image_lib->initialize($config);
                                
                        if(!$this->image_lib->resize())
                        {
                            echo "Image is not resized"."<br>";
                            echo $this->image_lib->display_errors();
                                    $this->image_lib->clear();
                        }
                    }
                }
            }
            else
            {
                $newfilename2=$old_client_logo;
                
            }
		$data=array('client_name'=>$client_name,'client_logo'=>$newfilename2,'nature_of_work'=>$nature_of_work,'description'=>$client_desc,);
		if($id=="")
		{
			$this->aqadmin_model->insert('exp_clients',$data);
		}
		
		else
		{
			$con=array('id'=>$id);
			$this->aqadmin_model->updatedata('exp_clients',$data,$con);
		}
		$this->session->set_flashdata('success_msg', 'Client added successfully');
    	redirect('aqadmin/view_clients');
		}
	}
	function edit_clients()
	{
		$id=$this->uri->segment(3);

		$con=array('id'=>$id);
	    $datas['client_row']=$this->aqadmin_model->select_single('exp_clients',$con);
	        
		$admin=$this->session->userdata('alogged_in');					
		$datas['login']=$admin;	
		$datas['active_menu']="clients";
		$this->load->view('layout/header_view',$datas);
		$this->load->view('layout/sidebar_view',$datas);
		$this->load->view('clients/add_clients',$datas);
		$this->load->view('layout/footer_view');
		
		
	}	
	function delete_client()
	{
		$id = $this->input->segment('id');
		$condn=array('id' => $id);
		$client_row=$this->aqadmin_model->select_single('exp_clients',$con);
		
		if($client_row->client_logo!=NULL || $client_row->client_logo!="")
		{
			$unlink="../uploads/client_logo/".$client_row->client_logo;
            unlink($unlink);
            $unlink="../uploads/client_logo/thumbs/".$client_row->client_logo;
            unlink($unlink);
		}
		$condn=array('id' => $id);
		$this->admin_model->delete_single('exp_clients',$condn);
		redirect('clients/view_clients');
	}
	function client_status_change()
	{
		$id = $this->input->get('id');
		$status = $this->input->get('sta');
		if($status == 1)
		{
			$data = array('active' => 0);
		}
		else
		{
			$data = array('active' => 1);
		}
		$condn=array('id' => $id);
		$this->admin_model->updatedata('exp_clients',$data,$condn);
		redirect('clients/view_clients');
	}
    function view_gallery()
	{
		$id = $this->input->get('id');
		$admin=$this->session->userdata('alogged_in');					
		$datas['login']=$admin;	
		$datas['client_id']=$id;
		$datas['active_menu']="clients";
		$this->load->view('layout/header_view',$datas);
		$this->load->view('layout/sidebar_view',$datas);
		$this->load->view('clients/view_gallery',$datas);
		$this->load->view('layout/footer_view');	
		
    }
    function add_gallery()
	{
		$id=$this->input->post('id');
		$this->form_validation->set_rules('client_id', 'Client','trim|required|xss_clean');
		if($this->form_validation->run() == FALSE)
		{
        	
        	if($id=="")
        	{
        		$admin=$this->session->userdata('alogged_in');					
				$datas['login']=$admin;	
				$datas['active_menu']="clients";
				$this->load->view('layout/header_view',$datas);
				$this->load->view('layout/sidebar_view',$datas);
				$this->load->view('clients/add_gallery',$datas);
				$this->load->view('layout/footer_view');
        	}
        	else
        	{
        		// redirect('aqadmin/edit_testimonials?id='.$id);
        	}
			
		}
		else
		{
			$client_id=$this->input->post('client_id');
			$imagecount=count($_FILES['image']['name']); 
			if($imagecount==0)
			{
				$this->session->set_flashdata('success_msg', 'Select atleast one image');
				$admin=$this->session->userdata('alogged_in');					
				$datas['login']=$admin;	
				$datas['active_menu']="clients";
				$this->load->view('layout/header_view',$datas);
				$this->load->view('layout/sidebar_view',$datas);
				$this->load->view('clients/add_gallery',$datas);
				$this->load->view('layout/footer_view');
			}
			else
			{
				$folder='gallery'.$client_id;
				$slug = url_title($folder, 'dash', true);
				mkdir("../uploads/gallery/".$slug);
				mkdir("../uploads/gallery/".$slug."/thumbs");
				if($imagecount>0)
				{
					for($i=0;$i<$imagecount;$i++)
					{
						if (!empty($_FILES['image']['name'][$i]))
						{
							$timage = filesize($_FILES["image"]["tmp_name"][$i]);
							$image_width = $timage[0];
							$image_height = $timage[1];
							$ext=pathinfo($_FILES['image']['name'][$i], PATHINFO_EXTENSION);
							$filename=$_FILES['image']['name'][$i];
							//$imgname = current(explode(".",$_FILES['images']['name'][$i]));
							$extarray = array("jpg","JPG","JPEG","jpeg","png","PNG");
							   
							if(in_array($ext,$extarray))
							{ 
								$this->load->helper("url");	
				        		$basepath =  "../uploads/gallery/".$slug."/"; 			 
								$randomnumber = rand(1234,4321);			
								$newfilename2 = $slug."-gallery-".$randomnumber. "." . $ext;           
								$target_path = $basepath . $newfilename2;              
			                  
						
								if (move_uploaded_file($_FILES['image']['tmp_name'][$i],$target_path))
								{	
									$img_url = $target_path;
			                        $basepath1 = "../uploads/gallery/".$slug."/thumbs/";
			                        $resize_path1 = $basepath1 . $newfilename2 ;
			                        $this->load->library('image_lib');
			                        $config['image_library'] = 'gd2';
			                        $config['source_image']  = $target_path;
			                        $config['create_thumb'] = FALSE;
			                        $config['maintain_ratio'] = TRUE;
			                        $config['new_image']  =$resize_path1;
			                        $config['width'] = 100;
			                        $config['height'] = 100;
			                        //$config['master_dim'] = 'height';
			                              
			                        $this->image_lib->initialize($config);
			                                
			                        if(!$this->image_lib->resize())
			                        {
			                            echo "Image is not resized"."<br>";
			                            echo $this->image_lib->display_errors();
			                                    $this->image_lib->clear();
			                        }
									$data=array('client_id'=>$client_id,'image'=>$newfilename2,'slug'=>$slug);
									$this->aqadmin_model->insert('exp_gallery',$data);
								}
								else
								{
									echo "error";
									exit();
								}
								
			          		}
			        	}
						
					}
				}
				$this->session->set_flashdata('success_msg', 'Gallery images added');
				redirect('aqadmin/add_gallery');
			}
			
		}
		
	}
	function delete_image()
	{
		$id=$this->input->get('id');
		$condn=array('id'=>$id);
		$image_row=$this->aqadmin_model->select_single('exp_gallery',$condn);

		$unlink="../uploads/gallery/".$image_row->slug."/".$image_row->image;
        unlink($unlink);
        $unlink="../uploads/gallery/".$image_row->slug."/thumbs/".$image_row->image;
        unlink($unlink);

        $condn=array('id'=>$id);
        $this->aqadmin_model->delete_single('exp_gallery',$condn);

        redirect('aqadmin/view_gallery?id='.$this->input->get('c_id'));
	}
    function logout()
	{    
     $this->session->unset_userdata('alogged_in');
     $this->session->sess_destroy();
	 redirect('aqadmin','refresh');
	}	
	function clear_cache()
    {
        $this->output->set_header("Cache-Control: no-store, no-cache, must-revalidate, no-transform, max-age=0, post-check=0, pre-check=0");
        $this->output->set_header("Pragma: no-cache");
    }
}
